/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <..\originlab\DialogEx.h> 

#include "Graphs.h"      // Resource IDs, in same location as this C file


class ScrollGraphDlg : public ResizeDialog
{
public:
	ScrollGraphDlg(BOOL bDeleteOnDestroy = FALSE) : ResizeDialog(IDD_SCROLL_GRAPH, "Graphs")
	{
		m_bDeleteOnDestroy = bDeleteOnDestroy;		
	}
	//virtual 
	int  DoModal(HWND hParent = NULL)
	{
		InitMsgMap();
		int nRet = Dialog::DoModal(hParent);//Launch the dialog
		return nRet;
	}	
	//virtual 
	int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		//Launch the modeless dialog
		int nRet = ResizeDialog::Create(hParent);
		
		return nRet;
	}
	
protected:
	
EVENTS_BEGIN
	ON_INIT( OnInitDialog ) 
	ON_SIZE( OnDlgResize )
	ON_DESTROY( OnDestroy )
	ON_SYSCOMMAND(OnSystemCommand)
	ON_SLIDE_BEFORE(IDC_SCROLL_SLIDER, OnSlide)
EVENTS_END		
	// *** Initialize Dialog on creation ***
	BOOL OnInitDialog()
	{
		m_bReady = false;
		//---- prepare our data for plotting
		string strWksPageName = "ScrollGraph";
		WorksheetPage wp(strWksPageName);
		if(wp) // book already existed, just use it
			m_wks = wp.Layers();
		else
		{
			int nDataPts = 30000;
			m_wks.Create(NULL, CREATE_HIDDEN); m_wks.SetSize(nDataPts, 2); m_wks.SetColDesignations("XY");
			Dataset da(m_wks, 0); da.Data(0, nDataPts);da *= 0.234;
			Dataset db(m_wks, 1); db.Normal(nDataPts); db += 15 * sin(da * 10 * 2 * PI / nDataPts);
			m_wks.GetPage().Rename(strWksPageName);
		}
		//----
		
		ResizeDialog::OnInitDialog(IDC_SCROLL_GRAPH, "ScrollGraph");
		
		// initialize all data members of interface control
		m_staticInfo = GetItem( IDC_SCROLL_INFO );
		m_slide = GetItem(IDC_SCROLL_SLIDER);
		Control control 	= GetItem( IDC_SCROLL_GRAPH );
		HWND hWnd 			=  control.GetSafeHwnd();
		//Call create control to create graphs, using holder ID and rect
		m_gpControl.CreateControl(hWnd);
		m_gpControl.Create( NOCLICK_TICKLABEL | NOCLICK_LAYERICON | NOCLICK_LAYER | NOCLICK_DATA_PLOT | NOCLICK_LABEL );
		
		plotToGraphControl( m_gpControl, IDM_PLOT_LINE, 0, 1 );
		initScrollRange();
		m_bReady = true;
		updateShowRange();
		return true;
	}
	BOOL OnDestroy()
	{
		m_wks.GetPage().Destroy();
		
		if(m_bDeleteOnDestroy)
		{
			delete this;
		}
		return true;
	}
	BOOL OnSlide(Control ctrl, UINT nCode, UINT nPos)
	{
		if(nCode == SB_ENDSCROLL)
			return true;
		
		m_nCurrent = nPos;
		if(m_bReady)
			updateShowRange();
		return true;
	}		
		
	// *** Re-size controls on re-sized Dialog ***
	// nType = SIZE_MAXIMIZED, SIZE_RESTORED etc, can be ignored
	// cx and cy are width and height of dialog   
	BOOL OnDlgResize( int nType, int cx, int cy )
	{
		int nx = 1;
		int ny = 1;
		
		ny = StretchControlWide(IDC_SCROLL_SLIDER, nx, ny, cx);
		ny = StretchControlWide(IDC_SCROLL_INFO, nx, ny, cx);
		SizeControl(IDC_SCROLL_GRAPH, cx - 2 * nx, cy - ny);
		PositionControl(IDC_SCROLL_GRAPH, nx, ny);		
		return TRUE;
	}
private:
	// *** Add plot to GraphControl ***
	bool plotToGraphControl( GraphControl& ogc, int nPlotType, int nX, int nY, bool bRescaleAll = true )
	{
		GraphPage gp = ogc.GetPage(); // Get page
		GraphLayer gl = gp.Layers();  // Get active layer
		string strColX = m_wks.Columns(nX).GetName();
		string strColY = m_wks.Columns(nY).GetName();
		Tree tr;
		construct_one_data_range(tr, m_wks, strColX, strColY, NULL, NULL, true);
		DataRange dr;
		dr.Create(tr);
		
		if( gl.AddPlot( dr, nPlotType ) < 0 )   // Plot curve in GraphControl
			return false;
		
		if( bRescaleAll )             // Rescale layer
			gl.Rescale();
		
		return true;
	}
	initScrollRange()
	{
		m_min = 1, m_max = 100, m_inc = 5;
		m_nCurrent = 20;
		m_slide.RangeMin = m_min;
		m_slide.RangeMax = m_max;
		m_slide.SetTicFreq(m_inc);
		m_slide.Position = m_nCurrent;
		Dataset da(m_wks, 0);
		Dataset db(m_wks, 1);
		da.GetMinMax(m_xmin, m_xmax);
	}
	void updateShowRange()
	{
		m_x1 = m_xmin + (m_xmax - m_xmin) * (m_nCurrent - m_inc - m_min)/(double)(m_max - m_min);
		m_x2 = m_xmin + (m_xmax - m_xmin) * (m_nCurrent + m_inc - m_min)/(double)(m_max - m_min);
		string str;
		str.Format("Data X [%s : %s],           display X [%s : %s],           X range = %s", ftoa(m_xmin), ftoa(m_xmax), ftoa(m_x1), ftoa(m_x2), ftoa(m_x2-m_x1));
		m_staticInfo.Text = str;
		GraphPage gp = m_gpControl.GetPage(); // Get page
		GraphLayer gl = gp.Layers();  // Get active layer
		Scale sc(gl.X);
		sc.From = m_x1;
		sc.To = m_x2;
	}
private:
	//--- scroll range related
	bool			m_bReady;
	int				m_min, m_max, m_inc, m_nCurrent;
	double			m_x1, m_x2;
	double			m_xmin, m_xmax;
	//---
	bool			m_bDeleteOnDestroy;
	Worksheet		m_wks;
	Control			m_staticInfo;
	Slider			m_slide;		
	GraphControl	m_gpControl;
};

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
bool testDlg()
{	
	ScrollGraphDlg GraphDlg;
	GraphDlg.DoModal( GetWindow() );
	return true;
}



void testPage()
{

	ScrollGraphDlg *pDlg = new ScrollGraphDlg(true);
	DialogPage dlgPage;
	
	dlgPage.Create(CREATE_VISIBLE, *pDlg);
}

	